{============================================================
 EsEngine header file
 by EsGames
 Version 0.4.5.9
 mail: EsEngine@mail.ru
 ===========================================================}
{$DEFINE DLL}
unit EsEngine;

interface

uses Windows,
     Direct3d9,
     D3dX9,
     sys_main;


const Eng_dll  = 'Es_Engine.dll';
      ENG_V    = '0.5.5.9';
      ENG_N    = 'EsEngine';
{===============================================================
Engine options.
===============================================================}
var   RU_LOG   : boolean;
      VB_COUNT : integer;
      DT_COUNT : integer;

{  }
const PROC_INIT   = 0;
      PROC_UPDATE = 1;
      PROC_RENDER = 2;
      PROC_FREE   = 3;
{   ( //)}
const L_NORM = 0;
      L_WARN = 1;
      L_ERR  = 2;

const R_BYTE  = 0;
      R_KBYTE = 1;
      R_MBYTE = 2;
      R_GBYTE = 3;

const E_NORM = 0;
      E_EXTR = 1;

const L_M_BTN  = 257;
      R_M_BTN  = 258;

const M_WORLD = 0;
      M_VIEW  = 1;
      M_PROJ  = 2;

const P_LIST    = 1;
      L_LIST    = 2;
      L_STRIP   = 3;
      T_LIST    = 4;
      T_STRIP   = 5;
      T_FAN     = 6;

const SHD_NONE  = 0;
      SHD_VSH   = 1;
      SHD_PSH   = 2;

const AANone    = 0;
      AA1x      = 1;
      AA2x      = 2;
      AA4x      = 3;
      AA8x      = 4;
      AA16x     = 5;

{c  }
const FVF2D  = D3DFVF_XYZRHW or D3DFVF_DIFFUSE;
      FVF2DT = D3DFVF_XYZRHW or D3DFVF_TEX1;
      FVF3D  = D3DFVF_XYZ    or D3DFVF_DIFFUSE;
      FVF3DT = D3DFVF_XYZ    or D3DFVF_TEX1;

{   }
var E_Mod : array[0..7] of PChar = ('[wnd]',
                                    '[Eng]',
                                    '[Rnd]',
                                    '[Fnt]',
                                    '[Shd]',
                                    '[Lit]',
                                    '[VBO]',
                                    '[Tex]');
{}  g_D3DObject : IDirect3D9;
    g_Device    : IDirect3DDevice9;


type

 TProcRender = procedure;
 TProcUpdate = procedure;
 TProcInit   = procedure;
 TProcFree   = procedure;


 {  }
 TVert2D = record
   x,y,z,rhw: single;
   color: DWORD;
 end;

 TVert2DTex = record
   x,y,z,rhw: single;
   tu,tv: single; // 
 end;

 TVert3D = record
   x,y,z: single;
   color: DWORD;
 end;

 TVert3DTex = record
   x,y,z: single;
   tu,tv: single; // 
 end;

 ARGBRecord = record
   a,r,g,b : single;
 end;

 {   }
 VertType =(V_2d,
            V_2DT,
            V_3d,
            V_3DT);

 {  }
 FiltType = (F_NONE,
             F_POINT,
             F_BILINEAR,
             F_TRILINEAR,
             F_ANISOTROPIC);

 IRender = interface
   function    Initialize(Handle: HWnd): HRESULT;stdcall;
    procedure   SetParametrs(AntiAlias,ZBufform,BPP: integer; Vsync: boolean); stdcall;
   procedure   SetWHW(Width,Height: integer; Windowed: boolean);stdcall;
   function    Reset : Hresult; stdcall;
   function    calcFPS : integer; stdcall;
   function    ShowSrFps  : integer; stdcall;
   procedure   Render; stdcall;
   procedure   SetClearColor(Color : DWORD); stdcall;
   function    GetMatrix(Mat_ID : Integer) : Td3dMatrix; stdcall;
   function    GetDevice : IDirect3DDevice9;
   procedure   LookAt(EyePt,LookPt,UpVec: TD3DXVector3;dist: single);
   Function    Vec3D(x,y,z: single): Td3dxVector3;
 end;

 IFont = interface
   function    CreateFont(ID: Cardinal): HRESULT; stdcall;
   procedure   PrintText(ID: Cardinal;x,y: integer; Text: string; Color: DWORD); stdcall;
   procedure   OnLostDev; stdcall;
   procedure   SetFont(ID: Cardinal;FontName: PChar; FontSize: Cardinal); stdcall;
   procedure   Free(ID: integer); stdcall;
 end;

 IVBO = interface
      procedure InitVB(ID: integer;VertType: VertType; VertNum: integer);  stdcall;
      procedure AddVert2d(ID: integer;x,y,z,rhw: single;color: Dword); stdcall;
      procedure AddVert2dTex(ID: integer;x,y,z,rhw,tu,tv:single); stdcall;
      procedure AddVert3d(ID: integer;x,y,z: single;color: Dword); stdcall;
      procedure AddVert3dTex(ID: integer;x,y,z,tu,tv:single); stdcall;
      procedure LoadVert(ID: integer;VertType: VertType); stdcall;
      procedure DrawVert(ID: integer;VertType: VertType;StVert, Count : integer);stdcall;
      procedure DrawVertEx(ID: integer;PrimitType: Integer; VertType: VertType;StVert, Count : integer); stdcall;
      procedure AddRect2d(ID: integer;x,y,z,rhw,w,h: single;color: DWord); stdcall;
      procedure AddRect2dTex(ID: integer;x,y,z,rhw,w,h:single); stdcall;
      procedure Free(Id: integer);
      procedure ReloadVert(ID: integer;StVert: integer) ; stdcall;
 end;

 ITexture = interface
   procedure LoadTexture(FileName: PChar); stdcall;
   procedure SetTexture(Stage: Cardinal; Num: integer); stdcall;
   procedure SetFiltration(FType : FiltType); stdcall;
   procedure SetAlphaBlend; stdcall;
   procedure OnLostDev; stdcall;
   procedure Free; stdcall;
 end;

 IWnd = interface
   procedure InitWnd; stdcall;
   procedure Close; stdcall;
   function  GetWindow : HWND; stdcall;
 end;

 IInput = interface
   function  KeyDown(key: integer): boolean; stdcall;
   procedure UpdateMousePos; stdcall;
   procedure SetMouse(Cent: boolean); stdcall;
 end;

 IShader = interface
    procedure Add(ShdType: integer; FuncName: PChar;
      FileName, Profile: PChar); stdcall;
    procedure Enable(ShdType: Integer); stdcall;
    procedure Free; stdcall;
 end;

 ILight = interface
    procedure AddDirLight(ID: integer; Dir : d3dVector; Range: single; Amb, Diff, Spec : TD3DColorValue; lEnable : boolean);
    procedure AddPointLight(ID: integer; Pos : d3dVector; Range: single; Amb, Diff, Spec : TD3DColorValue; Att0,att1,att2 : single; lEnable : boolean);
    function  SetColorS(a,r,g,b: single) : Td3dColorValue;
    function  SetColorR(ARGB: ARGBRecord) : Td3dColorValue;
    function  MakeARGBRecord(a,r,g,b : single) : ARGBRecord;
    Procedure EnableLight(ID : Integer; const lEnable : boolean = true);
    procedure free(Id : integer);
 end;

 ILog = interface
      procedure StartLog(FileName: PChar; const RuLog: boolean = false ); stdcall;
      procedure PrintLog(M_ID :Integer; Text: PChar; const Pr:integer=L_NORM); stdcall;
      procedure PauseLog(const Pause: boolean = true); stdcall;
      procedure LogSetting(ShowInfo: boolean; LoggingLevel: integer); stdcall;
      procedure EndLog; stdcall;
 end;

 IEngine = interface
    function  Initialize(_win : HWND): HRESULT; stdcall;
    procedure MainLoop(UPS: integer); stdcall;
    procedure EngExit(E_PR : integer = E_NORM); stdcall;
    procedure UpDate; stdcall;
    procedure Render; stdcall;
    procedure ResetTimer; stdcall;
    procedure SetProc(ID: integer; Proc : pointer); stdcall;
    function  GetProc(ID: integer) : pointer; stdcall;
    function  GetRndr  : IRender; stdcall;
    function  GetFnt   : IFont; stdcall;
    function  GetVBO   : IVBO; stdcall;
    function  GetTex   : ITexture; stdcall;
    function  GetLog   : ILog; stdcall;
    function  GetWnd   : IWND; stdcall;
    function  GetInp   : IInput; stdcall;
    function  GetShd   : IShader; stdcall;
    function  GetLght  : ILight; stdcall;
    Function  ShowEngVer: PChar;  stdcall;
 end;


 procedure Init;
 procedure DeInit;

 var
   EsEng : IEngine;
   EsRnd : IRender;
   EsFnt : IFont;
   EsVBO : IVBO;
   EsTex : ITexture;
   EsLog : ILog;
   EsWnd : IWnd;
   EsInp : IInput;
   EsShd : IShader;
   EsLit : ILight;
   GlobalError : boolean;
 implementation
 {$IFDEF DLL}
 {$ELSE}
 uses
   Es_eng, Es_log;
{$ENDIF}

{$IFDEF DLL}
procedure CreateEngine(out Engine: IEngine); external eng_dll;
{$ELSE}
procedure CreateEngine(out Engine: IEngine);
begin
  if _eng = nil then
  begin
    _eng := TEng.CreateEng;
    Engine := _eng;
  end;
end;
{$ENDIF}


 procedure Init;
  begin
     CreateEngine(EsEng);
     EsLog:= EsEng.GetLog;
     EsLog.StartLog('log.txt');
     EsWND:= EsEng.GetWnd;
     EsWnd.InitWnd;
     EsRnd:= EsEng.GetRndr;
     EsFnt:= EsEng.GetFnt;
     EsVbO:= EsEng.GetVBO;
     EsTex:= EsEng.GetTex;
     EsInp:= EsEng.GetInp;
     EsShd:= EsEng.GetShd;
     EsLit:= EsEng.GetLght;
 end;


  procedure DeInit;
  begin
    EsLog.EndLog;
    EsInp:=nil;
    EsTex:=nil;
    EsVBO:=nil;
    EsFnt:=nil;
    EsRnd:=nil;
    EsWnd:=nil;
    EsEng:=nil;
    EsLog:=nil;
    EsShd:=nil;
    EsLit:=nil;
  end;

 initialization
   init;
 finalization
  {} DeInit;

end.
